/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.psu.inventory;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class PSUSlot {
    public static final PSUSlot EMPTY = new PSUSlot();
    public ResourceLocation registryName;
    private int count;

    public PSUSlot() {
        this.count = 0;
        this.registryName = new ResourceLocation("minecraft:air");
    }

    public PSUSlot(ResourceLocation itemIn, int countIn) {
        this.count = countIn;
        this.registryName = itemIn;
    }

    public PSUSlot(ItemStack stack) {
        this.registryName = stack.m_41720_().getRegistryName();
        this.count = stack.m_41613_();
    }

    public PSUSlot(CompoundTag tag) {
        this.readNBT(tag);
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getCount() {
        return this.count;
    }

    public void decrementCount(int dec) {
        this.count -= dec;
    }

    public void incrementCount(int inc, int cap) {
        this.count = Math.min(this.count + inc, cap);
    }

    public int incrementCount(int inc) {
        this.count += inc;
        return this.count;
    }

    public boolean isEmpty() {
        return this.count <= 0;
    }

    public ItemStack getStack() {
        return new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(this.registryName));
    }

    public CompoundTag writeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("Item", this.registryName.toString());
        tag.m_128405_("Count", this.count);
        return tag;
    }

    public void readNBT(CompoundTag tag) {
        if (!tag.m_128441_("Item")) {
            return;
        }
        this.registryName = new ResourceLocation(tag.m_128461_("Item"));
        this.count = tag.m_128441_("Count") ? tag.m_128451_("Count") : 0;
    }
}

